#ifndef _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_Windows_Functions
#define _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_Windows_Functions
///////////////////////////////////////////////////////////////////////////////////////////

void TextBoxWrite(HWND xHandle, char *xSrting)
{
  int Length = SendMessage(xHandle, WM_GETTEXTLENGTH, 0, 0);
  SendMessage(xHandle, EM_SETSEL, (WPARAM)Length, (LPARAM)Length);
  SendMessage(xHandle, EM_REPLACESEL, 0, (LPARAM)(LPSTR)xSrting);
}

///////////////////////////////////////////////////////////////////////////////////////////

void ErrorMessage(HWND xDialog, char *xMessage)
{
    HWND WindowHandle = NULL;

    if(xDialog == NULL) WindowHandle = GetActiveWindow();
    else WindowHandle = xDialog;

    MessageBox(WindowHandle, xMessage ,"Error",0 + MB_ICONHAND + MB_SYSTEMMODAL + MB_TASKMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////

void AlertMessage(HWND xDialog, char *xMessage, char *xTitle)
{
    HWND WindowHandle = NULL;

    if(xDialog == NULL) WindowHandle = GetActiveWindow();
    else WindowHandle = xDialog;

    MessageBox(WindowHandle, xMessage ,xTitle,0 + MB_SYSTEMMODAL + MB_TASKMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////

int Get_TextLength(HWND xWindow)
{
    return GetWindowTextLength(xWindow);
}

///////////////////////////////////////////////////////////////////////////////////////////

void Set_Text (HWND xDialog, char *xText)
{
    SendMessage(xDialog, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)xText);
}

///////////////////////////////////////////////////////////////////////////////////////////

int Get_TextEx (HWND WindowHandle, char *ReturnTemp, int MaxSize)
{
    int Length = GetWindowTextLength(WindowHandle);
    if(Length > MaxSize) return Length;

    GetWindowText(WindowHandle, ReturnTemp, Length + 1);

    ReturnTemp[Length] = '\0';

    return Length;
}

///////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally

char *Get_Text (HWND WindowHandle)
{
    int Length = GetWindowTextLength(WindowHandle);
    char *ReturnValue = (char *) calloc(Length + 1, 1);

    Get_TextEx(WindowHandle, ReturnValue, Length);
    return ReturnValue;
}

///////////////////////////////////////////////////////////////////////////////////////////

void CenterWindow (HWND hWnd)
{
    RECT wRect;

    GetWindowRect(hWnd, &wRect);

    DWORD x = (GetSystemMetrics(SM_CXSCREEN)-(wRect.right-wRect.left))/2;
    DWORD y = (GetSystemMetrics(SM_CYSCREEN)-(wRect.bottom-wRect.top+GetSystemMetrics(SM_CYCAPTION)))/2;

    SetWindowPos(hWnd,NULL,x,y,0,0,SWP_NOSIZE|SWP_NOZORDER);
}

///////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK Set_Color(int TxtColr, int BkColr, int wParam)
{
    static HBRUSH ReUsableBrush;
    DeleteObject(ReUsableBrush);
    ReUsableBrush = CreateSolidBrush(BkColr);
    SetTextColor((HDC)wParam,TxtColr);
    SetBkColor((HDC)wParam,BkColr);
    return (LRESULT)ReUsableBrush;
}

///////////////////////////////////////////////////////////////////////////////////////////

int IsMouseOverHwnd(HWND xHandle)
{
    RECT Rectangle;
    POINT Pointer;
    memset(&Rectangle, 0, sizeof(Rectangle));
    memset(&Pointer, 0, sizeof(Pointer));

    GetWindowRect(xHandle, &Rectangle);
    GetCursorPos(&Pointer);

    return PtInRect(&Rectangle, Pointer);
}

///////////////////////////////////////////////////////////////////////////////////////////

HFONT MakeFont(char *Font, int PointSize)
{
    HDC hDC;
    int CyPixels;
    hDC = GetDC(HWND_DESKTOP);
    CyPixels = GetDeviceCaps(hDC, LOGPIXELSY);
    ReleaseDC(HWND_DESKTOP, hDC);
    PointSize = (PointSize * CyPixels)/72;
    return CreateFont(0-PointSize, 0, 0, 0, FW_NORMAL, 0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_DONTCARE, Font);
}

///////////////////////////////////////////////////////////////////////////////////////////

void SetFont(HWND xHandle, HFONT FontHandle)
{
    SendMessage( xHandle , WM_SETFONT, (WPARAM)FontHandle, (LPARAM)TRUE );
}

///////////////////////////////////////////////////////////////////////////////////////////
#endif

